/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.managed.HwmcaObjectProperties;
import com.ibm.hwmca.fw.managed.HwmcaParentObjectProperties;
import com.ibm.hwmca.fw.managed.ManagedObjectGroupProperties;
import com.ibm.hwmca.fw.managed.ManagedObjectProperties;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.managed.TaskProperties;
import com.ibm.hwmca.fw.settings.user.ObjectLockingSettings;
import com.ibm.hwmca.fw.settings.user.UserSettings;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.ui.LockedObjects;
import com.ibm.hwmca.fw.ui.PropertyNames;
import com.ibm.hwmca.fw.ui.UIGroup;
import com.ibm.hwmca.fw.ui.UIHwmcaObject;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIListener;
import com.ibm.hwmca.fw.ui.UIListenerData;
import com.ibm.hwmca.fw.ui.UIManagedObject;
import com.ibm.hwmca.fw.ui.UIManagedObjectGroup;
import com.ibm.hwmca.fw.ui.UIRequests;
import com.ibm.hwmca.fw.ui.UIResponses;
import com.ibm.hwmca.fw.ui.UITask;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UIApp
implements UIRequests,
UIResponses,
HwmcaParentObjectProperties,
ManagedObjectProperties,
ManagedObjectGroupProperties,
HwmcaObjectProperties,
TaskProperties {
    private String taskletClassName = "com.ibm.hwmca.fw.ui.UITasklet";
    private ArrayList classNames;
    private ArrayList propertyNames;
    private LockedObjects lockedObjects;
    private Map userSettings;
    private Client client;
    private ObjectLockingSettings lockSettings;
    private HashMap uiObjects = new HashMap();
    private static final String TRACE_MASKT = "HUIT  CT";
    private static final String TRACE_MASKF = "HUIT  CF";
    private static final String TRACE_MASKD = "HUIT  CD";

    public void setTaskletName(String taskletClassName) {
        this.taskletClassName = taskletClassName;
    }

    public void addHwmcaObjectClassName(String fullClassName) {
        if (this.classNames == null) {
            this.classNames = new ArrayList();
        }
        this.classNames.add(fullClassName);
    }

    public void addHwmcaObjectClassName(String[] names) {
        if (this.classNames == null) {
            this.classNames = new ArrayList();
        }
        int i = 0;
        while (i < names.length) {
            this.classNames.add(names[i]);
            ++i;
        }
    }

    public void addPropertyNames(PropertyNames names) {
        if (this.propertyNames == null) {
            this.propertyNames = new ArrayList();
        }
        this.addPropertyNames(names);
    }

    public void addPropertyNames(PropertyNames[] names) {
        if (this.propertyNames == null) {
            this.propertyNames = new ArrayList();
        }
        int i = 0;
        while (i < names.length) {
            this.propertyNames.add(names[i]);
            ++i;
        }
    }

    public void startManagedObjectLoop(UIListener uiListener) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UIApp.startTasklet()");
        if (this.userSettings == null) {
            this.getUserSettings();
        }
        this.sendListenerData();
        ListenerThread thread = new ListenerThread(this.client, uiListener);
        thread.start();
    }

    public Map getUserSettings() throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UIApp.getUserSettings()");
        TaskletRequest request = new TaskletRequest();
        request.setData("Request", "UserSettings");
        TaskletResponse response = this.getClient().request(request);
        this.userSettings = (Map)response.getData("UserSettings");
        if (this.userSettings != null) {
            this.lockSettings = (ObjectLockingSettings)this.userSettings.get("com.ibm.hwmca.base.settings.user.ObjectLockingSettings");
        }
        Trace.trace(TRACE_MASKF, "<- UIApp.getUserSettings()");
        return this.userSettings;
    }

    private Client getClient() throws TaskletException {
        if (this.client == null) {
            this.client = new Client(this.taskletClassName, null);
            TaskletResponse taskletResponse = this.client.init();
        }
        return this.client;
    }

    private TaskletResponse sendListenerData() throws TaskletException {
        Iterator iterator;
        int next;
        Trace.trace(TRACE_MASKD, "-> UIApp.sendListenerData()");
        TaskletResponse response = null;
        int size = 0;
        String[] cNames = null;
        PropertyNames[] pNames = null;
        if (this.classNames != null) {
            size = this.classNames.size();
            cNames = new String[size];
            next = 0;
            iterator = this.classNames.iterator();
            while (iterator.hasNext()) {
                cNames[next++] = (String)iterator.next();
            }
        }
        if (this.propertyNames != null) {
            size = this.propertyNames.size();
            pNames = new PropertyNames[size];
            next = 0;
            iterator = this.propertyNames.iterator();
            while (iterator.hasNext()) {
                pNames[next++] = (PropertyNames)iterator.next();
            }
        }
        if (cNames != null || pNames != null) {
            TaskletRequest request = new TaskletRequest();
            request.setData("Request", "ListenerData");
            request.setData("ListenerData", new UIListenerData(cNames, pNames));
            response = this.getClient().request(request);
        }
        Trace.trace(TRACE_MASKD, "<- UIApp.sendListenerData()");
        return response;
    }

    private LockedObjects getLockedObjects() {
        if (this.lockedObjects == null) {
            this.lockedObjects = LockedObjects.getLockedObjects();
        }
        return this.lockedObjects;
    }

    private void addLocks(UIHwmcaObject[] uiObjects) {
        Trace.trace(TRACE_MASKF, "-> UIApp.addLocks()");
        ObjectId[] ids = this.getLockObjectIds(uiObjects);
        if (ids != null) {
            this.getLockedObjects().lock(ids);
        }
        Trace.trace(TRACE_MASKF, "<- UIApp.addLocks()");
    }

    private void removeLocks(UIHwmcaObject[] uiObjects) {
        ObjectId[] ids;
        Trace.trace(TRACE_MASKF, "-> UIApp.removeLocks()");
        if (this.lockSettings != null && this.lockSettings.getLock() && (ids = this.getLockObjectIds(uiObjects)) != null) {
            this.getLockedObjects().unlock(ids);
        }
        Trace.trace(TRACE_MASKF, "<- UIApp.removeLocks()");
    }

    private ObjectId[] getLockObjectIds(UIHwmcaObject[] uiObjects) {
        ObjectId[] result = null;
        int count = 0;
        int i = 0;
        while (i < uiObjects.length) {
            if (uiObjects[i] instanceof UIManagedObject) {
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            result = new ObjectId[count];
            int j = 0;
            int i2 = 0;
            while (i2 < uiObjects.length) {
                if (uiObjects[i2] instanceof UIManagedObject) {
                    result[j++] = uiObjects[i2].getObjectId();
                }
                ++i2;
            }
        }
        return result;
    }

    class ListenerThread
    extends Thread {
        private Client client;
        private UIListener uiListener;
        private static final String MOM = "com.ibm.hwmca.fw.managed.ManagedObjectManager";
        private static final String USER = "com.ibm.hwmca.fw.managed.User";

        ListenerThread(Client client, UIListener uiListener) {
            this.client = client;
            this.uiListener = uiListener;
            this.setName("UI Application listener thread");
        }

        public void run() {
            Trace.trace(UIApp.TRACE_MASKF, "-> UIApp.ListenerThread.run()");
            try {
                TaskletResponse response = null;
                TaskletRequest request = new TaskletRequest();
                request.setData("Request", "StartListening");
                response = this.client.request(request);
                boolean loggedOn = true;
                do {
                    try {
                        if (response.getData("Logoff") != null) {
                            this.uiListener.logoff();
                            loggedOn = false;
                        } else {
                            ArrayList events = (ArrayList)response.getData("PropertyChange");
                            int size = events.size();
                            Trace.trace(UIApp.TRACE_MASKF, "   number of events from UITasklet is " + size);
                            int i = 0;
                            while (i < size) {
                                PropertyChangeEvent evt = (PropertyChangeEvent)events.get(i);
                                ObjectId source = (ObjectId)evt.getSource();
                                if (source.isInstanceOf(MOM)) {
                                    this.momPropertyChange(evt);
                                } else if (source.isInstanceOf(USER)) {
                                    this.userSettingsPropertyChange(evt);
                                } else {
                                    this.objectPropertyChange(evt);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Exception exc) {
                        Trace.trace(UIApp.TRACE_MASKF, "UIApp caught exception...");
                        Trace.trace(UIApp.TRACE_MASKF, exc);
                        exc.printStackTrace();
                    }
                    request.setData("Request", "GetUpdates");
                    response = this.client.request(request);
                    request = new TaskletRequest();
                } while (loggedOn);
                this.client.terminate();
            }
            catch (Exception exc) {
                Trace.trace(UIApp.TRACE_MASKF, "UIApp caught exception...");
                Trace.trace(UIApp.TRACE_MASKF, exc);
                exc.printStackTrace();
            }
            Trace.trace(UIApp.TRACE_MASKF, "<- UIApp.ListenerThread.run()");
        }

        void momPropertyChange(PropertyChangeEvent evt) {
            Trace.trace(UIApp.TRACE_MASKD, "-> UIApp.momPropertyChange()");
            UIHwmcaObject[] items = (UIHwmcaObject[])evt.getNewValue();
            if (items == null) {
                items = (UIHwmcaObject[])evt.getOldValue();
                if (UIApp.this.lockSettings != null && UIApp.this.lockSettings.getLock()) {
                    UIApp.this.removeLocks(items);
                }
                int i = 0;
                while (i < items.length) {
                    UIApp.this.uiObjects.remove(items[i].getObjectId());
                    ++i;
                }
                this.uiListener.inventoryRemove(items);
            } else {
                if (UIApp.this.lockSettings != null && UIApp.this.lockSettings.getLock()) {
                    UIApp.this.addLocks(items);
                }
                int i = 0;
                while (i < items.length) {
                    UIApp.this.uiObjects.put(items[i].getObjectId(), items[i]);
                    ++i;
                }
                this.uiListener.inventoryAdd(items);
            }
            Trace.trace(UIApp.TRACE_MASKD, "<- UIApp.momPropertyChange()");
        }

        void userSettingsPropertyChange(PropertyChangeEvent evt) {
            Trace.trace(UIApp.TRACE_MASKD, "-> UIApp.userSettingsPropertyChange()");
            Map newSettings = (Map)evt.getNewValue();
            Iterator iterator = newSettings.values().iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (next instanceof ObjectLockingSettings) {
                    boolean lockSettingsChanged = false;
                    if (UIApp.this.lockSettings == null) {
                        lockSettingsChanged = true;
                    } else if (!UIApp.this.lockSettings.equals(next)) {
                        lockSettingsChanged = true;
                    }
                    ObjectLockingSettings newLockSettings = (ObjectLockingSettings)next;
                    if (lockSettingsChanged && newLockSettings.getLock() != UIApp.this.lockSettings.getLock()) {
                        if (newLockSettings.getLock()) {
                            UIHwmcaObject[] array = UIApp.this.uiObjects.values().toArray(new UIHwmcaObject[0]);
                            UIApp.this.addLocks(array);
                        } else {
                            UIApp.this.lockedObjects.unlockAll();
                        }
                    }
                    UIApp.this.lockSettings = newLockSettings;
                    continue;
                }
                Trace.trace(UIApp.TRACE_MASKD, "   new settings: " + next);
                this.uiListener.userSettingsChanged((UserSettings)next);
            }
            UIApp.this.userSettings = newSettings;
            Trace.trace(UIApp.TRACE_MASKD, "<- UIApp.uerSettingsPropertyChange()");
        }

        void objectPropertyChange(PropertyChangeEvent evt) {
            Trace.trace(UIApp.TRACE_MASKD, "-> UIApp.objectPropertyChange()");
            UIHwmcaObject uiObject = (UIHwmcaObject)UIApp.this.uiObjects.get(evt.getSource());
            if (uiObject == null) {
                Trace.trace(UIApp.TRACE_MASKD, "   could not find ObjectId " + evt.getSource());
                Trace.trace(UIApp.TRACE_MASKD, "   ignoring event: " + evt);
            } else {
                Object newValue = evt.getNewValue();
                Object oldValue = evt.getOldValue();
                String propertyName = evt.getPropertyName();
                Trace.trace(UIApp.TRACE_MASKD, "   UIApp got PropertyChangeEvent from " + uiObject);
                Trace.trace(UIApp.TRACE_MASKD, "   propertyName is " + propertyName);
                if (propertyName.equals("StatusAcceptable")) {
                    ((UIManagedObjectGroup)uiObject).setStatusAcceptable((Boolean)newValue);
                } else if (propertyName.equals("Status")) {
                    ((UIManagedObject)uiObject).setStatus((Status)newValue);
                } else if (propertyName.equals("Busy")) {
                    ((UIManagedObject)uiObject).setBusy((Boolean)newValue);
                } else if (propertyName.equals("UIInfo")) {
                    ((UIManagedObject)uiObject).setUIInfo((UIInfo)newValue);
                } else if (propertyName.equals("Children")) {
                    if (uiObject instanceof UIGroup) {
                        if (oldValue == null) {
                            ((UIGroup)uiObject).addChildren((ObjectId[])newValue);
                        } else {
                            ((UIGroup)uiObject).removeChildren((ObjectId[])oldValue);
                        }
                    }
                } else if (propertyName.equals("PermittedObjects")) {
                    ((UITask)uiObject).setPermittedObjects((Set)newValue);
                } else {
                    Trace.trace(UIApp.TRACE_MASKD, "   unknown property name: " + propertyName);
                    Trace.trace(UIApp.TRACE_MASKD, "   ignoring event: " + evt);
                }
            }
            Trace.trace(UIApp.TRACE_MASKD, "<- UIApp.objectPropertyChange()");
        }
    }
}

